function initOptimyar() {
    console.log("optimyar.....");
    window.sessionMetadata=null;
    const meetingId = sessionStorage.getItem("BBB_meetingID");
    const userId = sessionStorage.getItem("BBB_externUserID");
    const fullName = sessionStorage.getItem("BBB_fullname");
    const axiosInstance = axios.create({
        baseURL: "https://api.optimyar.com",
    });
    axiosInstance.get(`getMeetingInfoByInteralId/${meetingId}`)
        .then(response => {
            const result = response.data;
            if (!result || result.returncode!=="SUCCESS") {
                return;
            }
            const info= result.attendees.attendee;
            window.sessionMetadata= {...result.metadata};
            let attendees=[];
            if (Array.isArray(info)==false){
                attendees=[info];
            }else{
                attendees=info;
            }

            const user = attendees.find(x=>x.userID===userId);

            if (user && user.role==="MODERATOR"){
                console.warn("user is manager");
            }else{
                if (window.sessionMetadata.disallowrecording){
                    addRefreshButton();
                    initForUser(userId,fullName);
                }
                removeUserCount();
            }

        })
        .catch(error => {
            console.error("getMeetingInfoByInteralId!!! ", error);
        });

}
function removeUserCount(){
    const userColumn = document.querySelector("div[class^='userListColumn-']");
    const container= userColumn.querySelector("div[class^='container-']");
    const h2El= container.querySelector("h2[class^='smallTitle-']");
    h2El.style.display="none";
}
function getToken(){
    let token = sessionStorage.getItem("optimyarToken");
    if (!token) {
        var decodedCookie = decodeURIComponent(document.cookie);
        var ca = decodedCookie.split(';');

        var userInfoStr = ca.find(c => c.trim().startsWith("OPTIMYAR-USER-INFO"));
        if (userInfoStr != null) {
            var str = userInfoStr.replace("OPTIMYAR-USER-INFO=","");

            var userInfo = JSON.parse(str);
            token = userInfo.token;
        }
    }
    return token;
}
function initForUser(userId,name) {
    window.allowClose = true;
    const token = getToken();
    if (token) {
        const axiosInstance = axios.create({
            baseURL: "https://api.optimyar.com",
            headers: {
                Authorization: `Bearer ${token}`
            }
        });
        axiosInstance.get("checkSessionLicence")
            .then(response => {
                const result = response.data;
                if (!result) {
                    console.error("user must not be admin");
                    closeSession();
                }
                window.setWaterMark(null, result);
            })
            .catch(error => {
                console.error("checkSessionLicence!!! ", error);
                closeSession();
            });
    }else{
        const phoneNo= userId.split("-").pop();
        window.setWaterMark(null, {name,phoneNo});
    }

}

function addRefreshButton(){
    const navBar = document.querySelector("div[class^='center-']");
    if (navBar){
        var button = document.createElement("Button");
        button.innerHTML = '<img class="icon" src="https://resource.optimyar.com/bbb/reload.png">';
        button.classList.add('refresh-button');
        button.onclick=()=>{
            window.isRefreshClick=true;
            setTimeout(()=>{
                window.location.reload(true);
                window.isRefreshClick=false;
            },200);
            setTimeout(()=>{
                window.isRefreshClick=false;
            },1500);
        }
        navBar.style.position = 'relative';
        navBar.appendChild(button);
    }
}

function closeSession(){

}
function getRandomNumber(from, to) {
    return Math.floor((Math.random() * to) + from);
}
function appendHtml(e, t) {
    var n = document.createElement("div");
    for (n.innerHTML = t; n.children.length > 0;) e.appendChild(n.children[0])
}

//<editor-fold desc="watermark">
function addImageWatermark(){
    setInterval(()=>{
        var videoEl = document.querySelector("[class^='screenshareContainer']");
        if (videoEl){
            const exist = videoEl.querySelector(".vjs-watermark-content-image");
            if (exist){
                return;
            }
            var img = document.createElement('img');
            var div = document.createElement('div');

            img.src = "https://resource.optimyar.com/bbb/logo.png";
            img.style.width = "100%";
            img.style.opacity= 0.3;
            div.classList.add('vjs-watermark-content-image'); // set text font size
            div.classList.add("vjs-watermark-center");
            div.appendChild(img);
            setTimeout(function () {
                videoEl.appendChild(div);
            }, 1000);
        }
    },2*60*1000);
}
function* shuffle(array) {
    let i = array.length;
    while (i--) {
        yield array.splice(Math.floor(Math.random() * (i+1)), 1)[0];
    }
}
function addWatermark(videoEl, data,position) {
    let {name, phoneNo} = data;
    name = name.replace(" null","");
    const fontSize=2; //percent;

    if (videoEl==null){
        videoEl = document.querySelectorAll("[class^='screenshareContainer']");
        if (videoEl && videoEl.length > 0){
            videoEl = videoEl[0];
        }else{
            videoEl= document.querySelectorAll("[class^='presentationArea']");
            if (videoEl && videoEl.length > 0){
                videoEl = videoEl[0];
            }
        }
        if (videoEl==null){
            console.error("videoEl is null !!! ");
            return;
        }
    }

    var div = document.createElement('div');
    var text = document.createElement('span');
    text.innerText = `${name} \n\n ${phoneNo}`;
    text.style.fontSize = `${fontSize}%`;
    div.style.zIndex=999999;

    const updateWatermarkFontSize = function updateWatermarkFontSize() {
        var height = videoEl.clientWidth;
        var trueSize = height / 100 * parseFloat(fontSize);
        text.style.fontSize = trueSize + 'px';
    };

    window.addEventListener('resize', updateWatermarkFontSize);
    document.addEventListener('onfullscreenchange',updateWatermarkFontSize);

    setTimeout(updateWatermarkFontSize, 1000);

    div.classList.add("vjs-watermark-content");
    div.classList.add("vjs-watermark-"+position);
    div.appendChild(text);

    setTimeout(function () {
        videoEl.appendChild(div);
        div.classList.add("animate__animated");
        div.classList.add("animate__lightSpeedInLeft");
    }, 1000);

    setTimeout(()=>{
        div.classList.add("animate__lightSpeedOutRight");
        setTimeout(()=>{
            document.querySelectorAll(`.vjs-watermark-content`).forEach(el => el.remove());
        },2000);
    },22*1000)
}


window.setWaterMark=(videoEl,userInfo)=>{
    let positions= shuffle(['top-left','top-right','bottom-right','bottom-right']);
    let next = positions.next().value;
    addWatermark(videoEl,userInfo,next);
    addImageWatermark();
    setInterval(()=>{
        next = positions.next().value;
        if (!next){
            positions= shuffle(['top-left','top-right','bottom-right','bottom-right']);
            next = positions.next().value;
        }
        addWatermark(videoEl,userInfo,next);
    },60*1000*2);
}

////</editor-fold>


//<editor-fold description="just for b3">
document.addEventListener('gesturestart', function (e) {
    e.preventDefault();
});
document.addEventListener('readystatechange', event => {

    // When HTML/DOM elements are ready:
    if (event.target.readyState === "interactive") {   //does same as:  ..addEventListener("DOMContentLoaded"..
        console.log("interactive");
        setTimeout(()=>{
            initOptimyar();
        },5*1000);
    }
    // When window loaded ( external resources are loaded too- `css`,`src`, etc...)
    if (event.target.readyState === "complete") {
        console.log("load complete");
    }
});
// window.onload = function() {
//     window.addEventListener("beforeunload", function (e) {
//         if (window.allowClose && !window.isRefreshClick){
//             e.preventDefault();
//             window.opener=null;
//             window.close();
//             return false;
//         }

//         var confirmationMessage ='آیا برای خروج از جلسه اطمینان دارید؟ ';

//         (e || window.event).returnValue = confirmationMessage; //Gecko + IE
//         return confirmationMessage; //Gecko + Webkit, Safari, Chrome etc.
//     });
// };

//</editor-fold>

