'use strict';
const {sanitizeEntity} = require('strapi-utils');
/**
 * Read the documentation (https://strapi.io/documentation/v3.x/concepts/controllers.html#core-controllers)
 * to customize this controller
 */

module.exports = {
  async create(ctx) {
    const toSave = ctx.request.body;
    let isValid = await strapi.services.course.isValid(toSave);
    if (isValid !== true) {//is string
      return ctx.badRequest(null, isValid);
    }
    const levelIds = await toSave.course_levels.reduce(async (memo, l) => {
      const results = await memo;
      const ids = await strapi.services.helpers.saveListEntity("session", l.sessions);
      l.sessions = ids;
      const level = await strapi.services["course-level"].create(l);
      return [...results, level._id];
    }, []);

    toSave.course_levels = levelIds;
    let entity = await strapi.services.course.create(toSave);
    return sanitizeEntity(entity, {model: strapi.models.course});
  }
};
