'use strict';
const axios = require('axios');
const xml2js = require('xml2js');
/**
 * Read the documentation (https://strapi.io/documentation/v3.x/concepts/services.html#core-services)
 * to customize this service
 */

module.exports = {
  isValidData(buyData, discount, levels = null) {
    if (discount && discount.isGroup && discount.minGroupCount > buyData.groupCount) {
      return "buyCourse.errors.invalidGroupCount"
    }
    if (levels != null) {
      const preLevels = levels.filter(x => x.status === "preRegister");
      if (preLevels.length > 0) {
        return "buyCourse.errors.courseIsNotForBuy";
      }
    }
    return true;
  },
  async getNextFactorNumber() {
    const obj = await strapi.query('user-course').find({_limit: 1, _sort: 'factorNumber:desc'});
    if (obj == null || obj.length === 0) {
      return 990001;//start number
    } else {
      return obj[0].factorNumber + 1;//next number
    }
  },
  async isLevelRunning(levelId) {
    try {
      const mInfo = await strapi.services.helpers.getBBBMeetingInfo(levelId);
      return mInfo.returncode === "SUCCESS" && mInfo.running === true && !mInfo.metadata.isprivate;
    } catch (ex) {
      strapi.services["system-log"].create({
        type: "getBBBMeetingInfo",
        message: ex
      });
      return false;
    }
  },
  async isUserCourseMeetingRunning(courseLevelInfo) {
    let adobeInfo = await strapi.services.helpers.isAdobeRunning(courseLevelInfo.id, true);
    if (adobeInfo !== false) {
      return {isAdobe: true, link: adobeInfo};
    } else {
      let levelId = courseLevelInfo.id;
      let isRunning = await this.isLevelRunning(courseLevelInfo.id);
      let isAdobe = null;
      if (!isRunning && courseLevelInfo.isGeneral && courseLevelInfo.course) {
        const courseInfo = await strapi.services.course.findOne({id: courseLevelInfo.course});
        const arr = courseInfo.course_levels.map(level => {
          return new Promise(async resolve => {
            adobeInfo = await strapi.services.helpers.isAdobeRunning(level.id, true);
            if (adobeInfo !== false) {
              resolve({isAdobe: true, link: adobeInfo});
            } else {
              const result = await this.isLevelRunning(level.id);
              if (result) {
                resolve(level.id);
              } else {
                resolve(false);
              }
            }
          })
        });
        const result = await Promise.all(arr);
        isAdobe = result.find(x => x.isAdobe);
        levelId = result.find(x => x !== false);
        isRunning = levelId != null;
      }
      if (isAdobe != null) {
        return isAdobe
      }
      return isRunning ? levelId : null;

    }

  },
  calculatePrice(buyCount, prices, discountPercent) {
    let sum = prices.reduce((a, b) => {
      return a + b;
    }, 0);
    sum = sum * buyCount;

    return sum - (sum * discountPercent / 100);
  },
  async areValidForBuy(levels) {
    const preLevels = levels.filter(x => x.status === "preRegister");
    return preLevels.length === 0;
  }
};
