const apiUrl = {
    menu: {
        list: {
            url: "menus",
            method: "get"
        }
    },
    company: {
        list: {
            url: "companies",
            method: 'get',
            setVersion:true
        }
    },
    media: {
        upload: {
            url: "upload",
            method: "post",
            setToken: true
        },
        download: {
            url: "upload/files/{id}",
            method: "get",
            setToken: true
        }
    },
    captcha: {
        sendBlackListAlert:{
            url:'captchas/sendBlackListAlert',
            method:'post',
            setToken:true
        },
        makeCaptcha: {
            url: 'captchas/make',
            method: 'get',
            setVersion:true
        },
        getPublicSessions: {
            url: 'getPublicSessions',
            method: 'get'
        },
        startPublicSession: {
            url: 'startPublicSession',
            method: 'post'
        },
        sendActiveCode: {
            url: "captchas/sendActiveCodeToUser",
            method: "post",
            setToken: true
        },
        isActiveCodeValid: {
            url: "captchas/isActiveCodeValid",
            method: "post",
            setToken: true
        },
        isActiveCodeExist: {
            url: "captchas/isActiveCodeExist",
            method: "post",
            setToken: true
        }
    },
    cert: {
        list: {
            url: "certifications/getCertifications",
            method: "post",
            setToken: false,
            body: {}
        }
    },
    auth: {
        userList: {
            url: "users",
            method: "get",
            setToken: true
        },
        makeCaptcha: {
            url: 'captchas/make',
            method: 'get',
            setVersion:true
        },
        login: {
            url: 'auth/local',
            method: 'post'
        },
        changePass: {
            url: "auth/reset-password",
            method: "post",
            setToken: true
        },
        sendToPhone: {
            url: "captchas/sendToPhone",
            method: "post"
        },
        register: {
            url: "auth/local/register",
            method: "post",
        },
        forgotPassword: {
            url: "auth/forgot-password",
            method: "post"
        },
        update: {
            url: 'users/{id}',
            method: 'put',
            setToken: true
        },
        addUserSession: {
            url: "user-sessions",
            method: "post",
            setToken: true
        },
        getUserSession: {
            url: "user-sessions/{id}",
            method: "get",
            setToken: true
        }
    },
    userSession: {
        list: {
            url: "user-sessions",
            method: "get",
            setToken: true
        },
        remove: {
            url: "user-sessions/{id}",
            method: "delete",
            setToken: true,
            needConfirm: true
        }
    },
    userPlayback: {
        list: {
            url: "user-playbacks",
            method: "get",
            setToken: true
        },
        recent: {
            url: "user-playbacks/getRecentPlaybacks/{id}",
            method: "get",
            setToken: true
        }
    },
    favorite: {
        list: {
            url: "favorites",
            method: "get",
            setToken: true
        },
        add: {
            url: "favorites",
            method: "post",
            setToken: true
        },
        remove: {
            url: "favorites/{id}",
            method: "delete",
            setToken: true
        }
    },
    discount: {
        list: {
            url: "discounts",
            method: "get",
            setToken: true
        },
        getById: {
            url: "discounts/{id}",
            method: "get",
            setToken: true
        },
        add: {
            url: "discounts",
            method: "post",
            setToken: true
        },
        update: {
            url: "discounts/{id}",
            method: "put",
            setToken: true
        },
        remove: {
            url: "discounts/{id}",
            method: "delete",
            setToken: true,
            needConfirm: true
        },
        getByCode: {
            url: "discounts/discountByCode/{code}",
            method: "get",
            setToken: true
        },
        getCurForCourse:{
            url: "discounts/getCurrentForLevel/{levelId}",
            method: "get",
            setToken: true
        },
    },
    session: {
        add: {
            url: "sessions",
            method: "post",
            setToken: true
        },
        getLiveUrl: {
            url: "sessions/joinUserToMeeting/{id}",
            method: "get",
            setToken: true
        },
        getResourcesForLevel: {
            url: "sessions/getResourcesForLevel/{id}",
            method: "get",
            setToken: true
        },
        list: {
            url: "sessions",
            method: "get",
            setToken: true
        },
        getMeetingSources: {
            url: 'sessions/getMeetingSources/{id}',
            method: 'get',
            setToken: true,
        },
        getSessionResources: {
            url: "sessions/getSessionResources/{id}",
            method: "get",
            setToken: true
        },
        saveSessionResources: {
            url: "sessions/saveSessionResources",
            method: "post",
            setToken: true
        }
    },
    playback: {
        refreshPlayback: {
            url: "user-playbacks/refreshPlayback",
            method: "post",
            setToken: true
        },
        stopPlayback: {
            url: "user-playbacks/stopPlayback",
            method: "post",
            setToken: true
        }
    },
    course: {
        list: {
            url: "courses?_sort=createdAt:DESC",
            method: "get",
            setToken: true
        },
        getById: {
            url: "courses/{id}",
            method: "get"
        },
        add: {
            url: "courses",
            method: "post",
            setToken: true
        },
        update: {
            url: "courses/{id}",
            method: "put",
            setToken: true
        },
    },
    courseLevels: {
        list: {
            url: "course-levels",
            method: "get",
            setToken: true
        },
        getById: {
            url: "course-levels/{id}",
            method: "get",
            setToken: true
        },
        isCourseLevelLive:{
            url: "course-levels/isCourseLevelLive/{id}",
            method: "get",
            setToken: true
        },
    },
    userCourse: {
        getCourseUsers:{
          url:"user-courses/getCourseUsers/{id}",
          method:"get",
            setToken: true
        },
        checkOfflineAccess:{
            url:"user-courses/checkOfflineAccess",
            method:"post",
            setToken: true
        },
        list: {
            url: "user-courses",
            method: "get",
            setToken: true,
            setVersion:true
        },
        add: {
            url: "user-courses",
            method: "post",
            setToken: true
        },
        getById: {
            url: "user-courses/{id}",
            method: "get",
            setToken: true
        },
        getFactorInfo:{
            url: "user-courses/getFactorInfo/{id}",
            method: "get",
        },
        pay: {
            url: "user-courses/pay",
            method: "post",
            setToken: true
        },
        verifyPay: {
            url: "user-courses/verifyPay",
            method: "post",
            setToken: true
        },
        isCourseLive:{
            url: "user-courses/isCourseLive/{id}",
            method: "get",
            setToken: true
        },
        enterClass: {
            url: "user-courses/joinUserToMeeting/{id}",
            method: "get",
            setToken: true
        }
    },
    userManage: {
        list: {
            url: "user-courses/getTeacherUsers",
            method: "get",
            setToken: true
        },
        update: {
            url: "user-courses/updateAccess",
            method: "post",
            setToken: true
        }
    }
};

window.apiUrl = apiUrl;
