Sets
S        /s1*s10/
D        /d1*d20/
C        /c1*c30/
;

Parameters
A(s)
f(d)
b(s)
trSD(s,d)
trDC(d,c)
p
dem(c)
capD(d)
capS(s)
;


A(s)     = uniform(1000,1500);
f(d)     = uniform(2000,3000);
b(s)     = uniform(5,10);
trSD(s,d)= uniform(1,2);
trDC(d,c)= uniform(0.5,0.7);
*p        = 15;
dem(c)   = uniform(50,100);
capD(d)  = uniform(500,1000);
capS(s)  = uniform(1000,2000);

***************

Free Variable
Z;

Binary Variables
y(s)
x(d)
;

Positive Variable
u(s)
QSD(s,d)
QDC(d,c)
;

Equations
obj
cons1
cons2
cons3
cons4
cons5
;

obj..    z =e=  p*sum({d,c},QDC(d,c)) - (sum(d,f(d)*x(d)) + sum(s,A(s)*y(s)) + sum({s,d},trSD(s,d)*QSD(s,d))
                                                   + sum({d,c},trDC(d,c)*QDC(d,c)) + sum(s,b(s)*u(s))) ;

cons1(s)..       u(s) =L= capS(s)*y(s);

cons2(d)..       sum(S,QSD(s,d))=L= capD(d)*x(d);

cons3(s)..       u(s) =e= sum(d,QSD(s,d));

cons4(d)..       sum(s,QSD(s,d)) =e= sum(c,QDC(d,c));

cons5(c)..       sum(d,QDC(d,c)) =l= dem(c);


Model SCND
/
obj
cons1
cons2
cons3
cons4
cons5
/
;

Options
mip = CPLEX
reslim =100
*maximum run time (sec.)
optcr = 0
;


for (p=10 to 15 by 1,
Solve SCND us mip max Z;

Display
"ouout for p"
p
Z.l
y.l
x.l
QSD.l
QDC.l
cons1.m
*use
;

);


*Parameters
*use(d);
*use(d)=sum(S,QSD.l(s,d));







