'use strict';

/**
 * Read the documentation (https://strapi.io/documentation/v3.x/concepts/services.html#core-services)
 * to customize this service
 */

module.exports = {
  async getByIds(ids) {//ids must be array
    return await strapi.query("course-level").find({
      id_in: ids
    })
  },
  async getTeacherLevels(teacherId) {
    try {
      const entities = await strapi.services["course-level"].find({teacher_eq: teacherId});
      return {
        result: true,
        entity: entities
      };
    } catch (ex) {
      return {
        result: false,
        entity: ex.message
      }
    }

  }
};
