'use strict';

/**
 * Read the documentation (https://strapi.io/documentation/v3.x/concepts/controllers.html#core-controllers)
 * to customize this controller
 */

module.exports = {

  async find(ctx) {
    let entities;
    const {query} = ctx;
    const {user} = ctx.state;
    query["teacher_eq"] = user.id;
    if (query._q) {
      entities = await strapi.services["course-level"].search(query);
    } else {
      entities = await strapi.services["course-level"].find(query);
    }

    if (query.status_nin && query.status_nin.findIndex(s => s === "finish") > -1) {

    } else {

    }

    return ctx.send(entities);
  },

  async isCourseLevelLive(ctx) {
    const {user} = ctx.state;
    const {id} = ctx.params;
    const response = {
      isAdobe: false,
      isLive: false,
      link: '',
    }
    const isBBBRun = await strapi.services.helpers.isBBBMeetingRunning(id);
    const isAdobeRun = await strapi.services.helpers.isAdobeRunning(id);
    response.isLive = isBBBRun || isAdobeRun;
    response.isAdobe = isAdobeRun;
    return ctx.send(response);
  }
};
